"""
Author: Owaiz Mustafa Khan
Email: owaiz.mustafakhan@rockwellautomation.com
"""


from typing import Optional

from pydantic import BaseModel, Field


class UpdateIndexFromDB(BaseModel):
    """
    Pydantic Class For Update Index From Database

        Args:
            ``collection_name`` : [str] The name of collection in which index metadata is present

            ``db_name`` : [str] The name of database in which the index metadata collection is present
    """
    collection_name: str = Field(
        default='index_info',
        title='Collection Name',
        description='The name of collection in which index metadata is present',
        alias='collection_name'
    )
    db_name: str = Field(
        default='ilens_default_info',
        title='Database Name',
        description='The name of database in which the index metadata collection is present',
        alias='db_name'
    )

class DeleteIndexNotInDB(UpdateIndexFromDB):
    """
        Pydantic Class For Delete Index Not Present In Database

            Args:
                ``collection_name`` : [str] The name of collection in which index metadata is present

                ``db_name`` : [str] The name of database in which the index metadata collection is present
        """
    pass

class DeleteIndex(BaseModel):
    name: str = Field(
        default=None,
        title='Index Name',
        description='The name of index is to be removed',
        alias='name'
    )
    collection_name: str = Field(
        default=None,
        title='Collection Name',
        description='The name of collection from which index is to be removed',
        alias='collection_name'
    )
    metadata_collection_name: str = Field(
        default='index_info',
        title='Metadata Collection Name',
        description='The name of collection which contains the index metadata',
        alias='metadata_collection_name'
    )
    db_name: str = Field(
        default=None,
        title='Database Name',
        description='The name of database in which the collection is present',
        alias='db_name'
    )
    metadata_db_name: str = Field(
        default='ilens_default_info',
        title='Metadata Database Name',
        description='The name of database in which metadata collection if present',
        alias='metadata_db_name'
    )
