"""
Author: Owaiz Mustafa Khan
Email: owaiz.mustafakhan@rockwellautomation.com
"""


import logging

from sqlalchemy import text

from sqlalchemy.engine import reflection
from sqlalchemy.orm import Session

from scripts.db.psql.databases import engine


def _table_has_column(table, column):
    insp = reflection.Inspector.from_engine(engine)
    has_column = False
    for col in insp.get_columns(table):
        if column != col["name"]:
            continue
        has_column = True
    return has_column


def _table_has_index(table, index):
    insp = reflection.Inspector.from_engine(engine)
    has_index = False
    for ind in insp.get_indexes(table):
        if index != ind["name"]:
            continue
        has_index = True
    return has_index


def create_index_from_data(index_data: dict):
    index = index_data["index"]
    if index_data.__contains__('new_index'):
        index = index_data['new_index']
    index_name = index["name"]
    columns = index["columns"]
    using = index.get("type", "btree").upper()
    unique = index.get("unique", False)
    schema = index_data.get("schema_name", "public")
    table_name = index_data["table_name"]

    column_str = ", ".join(f'"{col}"' for col in columns)
    unique_str = "UNIQUE " if unique else ""

    create_sql = (
        f'CREATE {unique_str}INDEX IF NOT EXISTS "{index_name}" '
        f'ON "{schema}"."{table_name}" USING {using} ({column_str});'
    )

    with engine.begin() as conn:
        conn.execute(text(create_sql))
        print(f"Created index: {index_name} on {schema}.{table_name}")

def drop_index_from_data(index_data: dict):
    index_name = index_data["index"]["name"]
    schema = index_data.get("schema_name", "public")  # fallback to 'public'

    drop_sql = f'DROP INDEX IF EXISTS "{schema}"."{index_name}";'

    with engine.begin() as conn:
        conn.execute(text(drop_sql))
        print(f"Dropped index: {schema}.{index_name}")


def recreate_index(index_data: dict):
    drop_index_from_data(index_data)
    create_index_from_data(index_data)
    print(f"Updated index: {index_data['new_index']['name']} on {index_data.get('schema_name', 'public')}.{index_data.get('table_name')}")
