"""
Author: Owaiz Mustafa Khan
Email: owaiz.mustafakhan@rockwellautomation.com
"""



from typing import Optional

from pydantic import BaseModel


class PostgresColumnConstraint(BaseModel):
    name: Optional[str] = None

class PostgresTableColumn(BaseModel):
    name: str
    data_type: str
    constraints: list[PostgresColumnConstraint]

class PostgresTableConstraint(BaseModel):
    type: str
    columns: list[str]

class PostgresTableIndex(BaseModel):
    name: str
    columns: list[str]
    unique: bool
    type: str

class PostgresTableBase(BaseModel):
    table_name: str
    indexes: list[PostgresTableIndex]

class PostgresTable(PostgresTableBase):
    columns: list[PostgresTableColumn]
    constraints: list[PostgresTableConstraint]
    priority: int

class PostgresTableSchemaBase(BaseModel):
    schema_name: str

class PostgresTableSchemas(PostgresTableSchemaBase):
    tables: list[PostgresTable]

class PostgresDefaultSchemaBase(BaseModel):
    database_name: str

class IndexBase(BaseModel):
    database_name: str
    schema_name: str
    table_name: str
    index: PostgresTableIndex


# Request

class PostgresDefaultSchema(PostgresDefaultSchemaBase):
    schemas: list[PostgresTableSchemas]

class AddIndex(IndexBase):
    pass

class UpdateIndex(IndexBase):
    pass

class DeleteIndex(BaseModel):
    name: str


# Responses

class GetTablesInfoResponse(BaseModel):
    data: list[PostgresDefaultSchema]

class AddIndexResponse(IndexBase):
    message: str = 'Successfully Added New Index'

class UpdateIndexResponse(IndexBase):
    message: str = 'Successfully Updated Index'

class DeleteIndexResponse(IndexBase):
    message: str = 'Successfully Deleted Index'

class UpdateIndexResponses(BaseModel):
    data: list[UpdateIndexResponse]