import time
from scripts.db.mongo import destination_mongo_client
from scripts.db.redis_connection import destination_space_db
from scripts.utils.mongo_utils import MongoCollectionBaseClass
from scripts.constants.db_constants import (
    CollectionNames,
    DatabaseNames,
)
from scripts.logging import logger


class CommonUtils:
    def __init__(self, space_id=None):
        self.unique_id = MongoCollectionBaseClass(
            mongo_client=destination_mongo_client,
            database=DatabaseNames.catalog_meta,
            collection=CollectionNames.unique_id,
            space_db=destination_space_db
        )
        self.unique_id.space_id = space_id

    @staticmethod
    def get_user_meta(user_id=None, check_flag=False):
        data_for_meta = {}
        if check_flag:
            data_for_meta["created_by"] = user_id
            data_for_meta["created_on"] = int(time.time() * 1000)
        data_for_meta["updated_by"] = user_id
        data_for_meta["updated_on"] = int(time.time() * 1000)
        return data_for_meta

    def get_next_id(self, param):
        try:
            next_id_doc = self.unique_id.find_one(query={"key": param})
            if not next_id_doc:
                insert_dict = {"key": param, "id": 100}
                self.unique_id.insert_one(data=insert_dict)
                return insert_dict["id"]
            else:
                query = {"key": param}
                count_value = int(next_id_doc["id"]) + 1
                new_values = {"id": count_value}
                self.unique_id.update_one(query=query, data=new_values, upsert=True)
                return int(new_values["id"])
        except Exception as e:
            logger.exception(f"Exception in creating ID: {e}")
            return None