from scripts.constants.db_constants import CollectionNames, DatabaseNames
from scripts.db.redis_connection import source_space_db
from scripts.utils.mongo_utils import MongoCollectionBaseClass


class ProcessConf(MongoCollectionBaseClass):
    def __init__(self, mongo_client, project_id=None):
        super().__init__(
            mongo_client, database=DatabaseNames.ilens_configuration, collection=CollectionNames.process_conf, space_db=source_space_db
        )
        self.space_id = project_id

    def find_all_processes(self, query=None):
        """
        The following function will give all tags for the given set of
        search parameters as keyword arguments
        :param self:
        :param query:
        :return:
        """
        all_process = self.find(query=query)
        if not all_process:
            return []
        return list(all_process)

    def find_by_process_id(self, process_id):
        """
        The following function will give one process for a given set of
        search parameters as keyword arguments
        :param process_id:
        :return:
        """
        one_process = self.find_one(query={"process_id": process_id})
        return one_process

    def find_by_project_id_process_name(self, process_name, project_id):
        """
        The following function will give one process for a given set of
        search parameters as keyword arguments
        :param process_id:
        :return:
        """
        one_process = self.find_one(query={"process_name": process_name, "project_id": project_id})
        return one_process

    def find_by_project_id(self, project_id):
        """
        The following function will give one process for a given set of
        search parameters as keyword arguments
        :param project_id:
        :return:
        """
        query = {"customer_project_id": project_id}
        many_process = self.find(query=query)
        if not bool(many_process):
            return []
        return list(many_process)

    def insert_one_process(self, data):
        """
        The following function will insert one tag in the
        tags collections
        :param self:
        :param data:
        :return:
        """
        return self.insert_one(data)

    def insert_many_process(self, data):
        """
        The following function will insert many tags in the
        tags collection
        :param self:
        :param data:
        :return:
        """
        return self.insert_many(data)

    def update_one_process(self, process_id, data, upsert=False):
        """
        The following function will update one tag in
        tags collection based on the given query
        """
        query_dict = {"process_id": process_id}
        return self.update_one(data=data, query=query_dict, upsert=upsert)

    def delete_many_process(self, query):
        """
        The following function will delete many tag in
        tags collection based on the given query
        :param self:
        :param query:
        :return:
        """
        if bool(query):
            response = self.delete_many(query=query)
            return response
        else:
            return False

    def delete_one_process(self, process_id):
        """
        The following function will delete one tag in
        tags collection based on the given query
        :param process_id:
        :return:
        """
        if process_id:
            return self.delete_one(query={"process_id": process_id})
        else:
            return False

    def find_process_by_aggregate(self, query):
        process = self.aggregate(query)
        if not process:
            return []
        return list(process)
