from typing import Any, Union

from scripts.db.redis_connection import destination_space_db
from scripts.utils.mongo_utils import MongoCollectionBaseClass

from scripts.constants.db_constants import (
    CollectionNames,
    DatabaseNames,
)
from scripts.logging import logger


class AssetRuleEngineMeta(MongoCollectionBaseClass):
    def __init__(self, mongo_client, space_id=None):
        super().__init__(
            mongo_client,
            database=DatabaseNames.catalog,
            collection=CollectionNames.asset_model_rule_engine,
            space_db=destination_space_db
        )
        self.space_id = space_id

    @property
    def key_space_id(self):
        return "space_id"

    def fetch_rule_details(self, list_of_asset_model_ids):
        try:
            pipeline = [
                {"$match": {"asset_model_id": {"$in": list_of_asset_model_ids}}},
                {
                    "$project": {
                        "_id": 0,
                        "ruleName": "$basic_info.ruleName",
                        "deviceDescription": "$basic_info.deviceDescription",
                        "Selected_ruleType": "$basic_info.Selected_ruleType",
                        "disable_all": {
                            "$cond": {
                                "if": {"$eq": ["$basic_info.disable_all", "True"]},
                                "then": "Disabled",
                                "else": "Enabled",
                            }
                        },
                    }
                },
            ]

            result = list(self.aggregate(pipeline))
            if not result:
                result = []
            return result

        except Exception as e:
            logger.error(f"Error occurred in the fetch rule details due to {str(e)}")

    def find_by_space(
        self, space_id: str, projections=None, sort=None, query_dict=None, limit=None, skip=0, **filters
    ) -> Union[Any, None]:
        query = {self.key_space_id: space_id}
        if query_dict:
            query |= query_dict
        if filters:
            query.update(filters)
        records = self.find(query, projections, sort=sort, limit=limit, skip=skip)
        return list(records) if records else None
