from scripts.constants.db_constants import AggregationKeys


class AssetDetailAggregate:
    @staticmethod
    def asset_model_version_list(project_id, asset_model_id):
        return [
            {
                AggregationKeys.match: {
                    "project_id": project_id,
                    "asset_model_id": asset_model_id,
                    "asset_rule": {AggregationKeys.exists: False},
                }
            },
            {AggregationKeys.project: {"_id": 0, "version_list": 1}},
            {AggregationKeys.project: {"version_list": 1, "value": {"$size": "$version_list"}}},
            {
                AggregationKeys.group: {
                    "_id": None,
                    "value": {AggregationKeys.push: AggregationKeys.value},
                    "name": {AggregationKeys.push: "$version_list"},
                }
            },
            {
                AggregationKeys.project: {
                    "_id": 0,
                    "version_list": {
                        AggregationKeys.arrayelemat: [
                            AggregationKeys.name,
                            {"$indexOfArray": [AggregationKeys.value, {"$max": AggregationKeys.value}]},
                        ]
                    },
                }
            },
        ]

    @staticmethod
    def fetch_resource_list(artifact_id, filters=None, filter_key=False):
        query = [
            {
                AggregationKeys.match: {
                    "artifact_id": {"$in": artifact_id},
                }
            },
            {AggregationKeys.unwind: AggregationKeys.KEY_RESOURCES},
            {AggregationKeys.project: {"_id": 0, "asset_model_id": 1, "asset_version": 1, "resources": 1}},
            {
                AggregationKeys.project: {
                    "resource_path": AggregationKeys.KEY_RESOURCE_RESOURCE_PATH,
                    "category": AggregationKeys.KEY_RESOURCE_CATEGORY,
                    "sub_category": AggregationKeys.KEY_RESOURCE_SUB_CATEGORY,
                    "resource_name": AggregationKeys.KEY_RESOURCE_RESOURCE_NAME,
                    "resource_description": "$resources.resource_description",
                    "resource_id": AggregationKeys.KEY_RESOURCE_RESOURCE_ID,
                    "resource_type": AggregationKeys.KEY_RESOURCE_RESOURCE_TYPE,
                    "is_svg": {"$ifNull": ["$resources.is_svg", False]},
                    "resource_config": "$resources.resource_config",
                    "asset_model_id": AggregationKeys.KEY_ASSET_MODEL_ID,
                    "asset_version": AggregationKeys.KEY_ASSET_VERSION,
                }
            },
        ]
        if filter_key:
            if filters.get("search"):
                search_query = {
                    "$or": [
                        {
                            AggregationKeys.KEY_RESOURCE_RESOURCE_NAME_PLAIN: {
                                AggregationKeys.regex: filters["search"],
                                AggregationKeys.options: "i",
                            }
                        },
                        {
                            AggregationKeys.KEY_RESOURCE_RESOURCE_DESC_PLAIN: {
                                AggregationKeys.regex: filters["search"],
                                AggregationKeys.options: "i",
                            }
                        },
                    ]
                }
            else:
                search_query = {
                    "$or": [
                        {
                            AggregationKeys.KEY_RESOURCE_RESOURCE_NAME_PLAIN: {
                                AggregationKeys.regex: "",
                                AggregationKeys.options: "i",
                            }
                        },
                        {
                            AggregationKeys.KEY_RESOURCE_RESOURCE_DESC_PLAIN: {
                                AggregationKeys.regex: "",
                                AggregationKeys.options: "i",
                            }
                        },
                    ]
                }
            query.insert(3, {AggregationKeys.match: search_query})
            if filters.get("sort_by"):
                if filters["sort_by"] == "asc":
                    sort_value = 1
                else:
                    sort_value = -1
                sort_query = {AggregationKeys.KEY_RESOURCE_RESOURCE_NAME_PLAIN: sort_value}
                query.insert(4, {AggregationKeys.sort: sort_query})
        return query
