import json
from functools import lru_cache


@lru_cache()
def get_db_name(redis_client, space_id: str, database: str, delimiter="__"):
    if not space_id:
        return database
    val = redis_client.get(space_id)
    if val is None:
        raise ValueError(f"Unknown Space, Space ID: {space_id} Not Found!!!")
    val = json.loads(val)
    if not val:
        return database

    # Get the prefix flag to apply space_id prefix to any db
    prefix_condition = bool(val.get("source_meta", {}).get("add_prefix_to_database"))

    if prefix_condition:
        # Get the prefix name from mongo or default to space_id
        prefix_name = val.get("source_meta", {}).get("prefix") or space_id
        return f"{prefix_name}{delimiter}{database}"
    return database


@lru_cache()
def get_redis_db_prefix(redis_client, space_id: str, delimiter="__"):
    if not space_id:
        return False
    val = redis_client.get(space_id)
    if val is None:
        return False
    val = json.loads(val)
    if not val:
        return False

    # Get the prefix flag to apply space_id prefix to any db
    prefix_condition = bool(val.get("source_meta", {}).get("add_prefix_to_database"))

    if prefix_condition:
        # Get the prefix name from mongo or default to space_id
        prefix_name = val.get("source_meta", {}).get("prefix") or space_id
        return f"{prefix_name}{delimiter}"
    return False


def get_space_data_from_redis(redis_client, space_id: str):
    record = redis_client.get(space_id)
    if record is None:
        raise ValueError(f"Unknown Space, Space ID: {space_id} Not Found!!!")
    if record := json.loads(record):
        return record
