import json

import os

from ut_mongo_util import mongo_client

from scripts.config.default_meta_catalog_constants import DEFAULT_USER_ROLES
from scripts.db.user import User
from scripts.db.user_role import UserRole
from scripts.db.redis_connection import user_role_permissions_redis
from scripts.logging import logger


class UserRolesPermissionKeys:
    required_keys = [
        each_key.strip()
        for each_key in os.environ.get(
            "USER_ROLE_KEYS",
            default="edit, create, view, publish, delete, "
            "clone, share,attachLicense, operator,"
            "auditLogs, screenshotRestriction, dashboard, title, auditLogsDownload, attachLicense, feedback, "
            "uploadLicense",
        ).split(",")
    ]


class UserRoleCreation:
    def __init__(self):
        """
        The __init__ function is called when the class is instantiated.
        It sets up the instance of the class, and defines all of its attributes.


        :param self: Represent the instance of the class
        :param : Pass the mongo client to the class
        :return: The following:
        """
        self.user_role_conn = UserRole(mongo_client=mongo_client)
        self.user_conn = User(mongo_client=mongo_client)

    @staticmethod
    def save_permissions(p_id, permissions, user_role_id):
        for permission_name, permissions_allowed in permissions.items():
            permissions_filtered = {x: y for x, y in permissions_allowed.items() if x in UserRolesPermissionKeys.required_keys}
            user_role_permissions_redis.hset(f"{p_id}__{user_role_id}", permission_name,
                                             json.dumps(permissions_filtered))

    def user_role_redis_update(self):
        """
        Function to update redis with the user roles
        """
        try:
            logger.info("Updating redis with user role details")
            space_details = self.user_conn.find({}, {"_id": 0, "space_id": 1, "userrole": 1})
            for each_space in space_details:
                all_roles = UserRole(mongo_client=mongo_client).find({"user_role_id": {"$in": each_space["userrole"]}})
                for user_r in all_roles:
                    user_role_id = user_r["user_role_id"]
                    permissions = user_r["user_role_permissions"]
                    self.save_permissions(each_space["space_id"], permissions, user_role_id)
            logger.info("Updated redis with user role details")
            return True
        except Exception as e:
            logger.exception("Failed to update redis with user roles", str(e))
            return False

    def create_user_role(self):
        try:
            for user_role in DEFAULT_USER_ROLES:
                self.user_role_conn.update_user_role({"user_role_id": user_role.get("user_role_id")}, user_role)
        except Exception as e:
            logger.error(f"Error creating public default data {str(e)}")
