from datetime import datetime

DEFAULT_USER_ROLES = [{
  "space_id": "space_099",
  "type": "edit",
  "user_role_id": "user_role_096",
  "access_levels": {
    "userManagement": {
      "access_level": True
    },
    "approvalInbox": {
      "access_level": True
    },
    "artifacts": {
      "access_level": True
    },
    "assetExplorer": {
      "access_level": True,
      "children": {
        "overview": False,
        "parameters": False,
        "alarms": False,
        "events": False,
        "serviceHistory": False,
        "rules": False,
        "resources": False,
        "dataMapping": False,
        "digitalTwin": False,
        "materials": False,
        "auditLogs": False,
        "insights": False,
        "treeView": False,
        "parameterData": False
      }
    }
  },
  "user_role_description": "Admin",
  "user_role_name": "Admin",
  "user_role_permissions": {
    "userManagement": {
      "key": "userManagement",
      "name": "User Management",
      "create": True,
      "delete": True,
      "edit": True,
      "view": True,
      "children": {
        "users": {
          "key": "users",
          "name": "User",
          "create": True,
          "delete": True,
          "edit": True,
          "view": True
        }
      }
    },
    "approvalInbox": {
      "key": "approvalInbox",
      "name": "Approval Inbox",
      "create": True,
      "delete": True,
      "edit": True,
      "view": True
    },
    "artifacts": {
      "key": "artifacts",
      "name": "artifacts",
      "create": True,
      "delete": True,
      "edit": True,
      "view": True
    }
  },
  "catalogPermission": True
},
{
  "space_id": "space_099",
  "type": "edit",
  "user_role_id": "user_role_097",
  "access_levels": {
    "userManagement": {
      "access_level": True
    },
    "approvalInbox": {
      "access_level": True
    },
    "artifacts": {
      "access_level": True
    },
    "assetExplorer": {
      "access_level": True,
      "children": {
        "overview": False,
        "parameters": False,
        "alarms": False,
        "events": False,
        "serviceHistory": False,
        "rules": False,
        "resources": False,
        "dataMapping": False,
        "digitalTwin": False,
        "materials": False,
        "auditLogs": False,
        "insights": False,
        "treeView": False,
        "parameterData": False
      }
    }
  },
  "user_role_description": "Reviewer",
  "user_role_name": "Reviewer",
  "user_role_permissions": {
    "userManagement": {
      "key": "userManagement",
      "name": "User Management",
      "create": True,
      "delete": True,
      "edit": True,
      "view": True,
      "children": {
        "users": {
          "key": "users",
          "name": "User",
          "create": True,
          "delete": True,
          "edit": True,
          "view": True
        }
      }
    },
    "approvalInbox": {
      "key": "approvalInbox",
      "name": "Approval Inbox",
      "create": True,
      "delete": True,
      "edit": True,
      "view": True
    },
    "artifacts": {
      "key": "artifacts",
      "name": "artifacts",
      "create": True,
      "delete": True,
      "edit": True,
      "view": True
    }
  },
  "catalogPermission": True
},
{
  "space_id": "space_099",
  "type": "edit",
  "user_role_id": "user_role_098",
  "access_levels": {
    "userManagement": {
      "access_level": True
    },
    "approvalInbox": {
      "access_level": True
    },
    "artifacts": {
      "access_level": True
    },
    "assetExplorer": {
      "access_level": True,
      "children": {
        "overview": False,
        "parameters": False,
        "alarms": False,
        "events": False,
        "serviceHistory": False,
        "rules": False,
        "resources": False,
        "dataMapping": False,
        "digitalTwin": False,
        "materials": False,
        "auditLogs": False,
        "insights": False,
        "treeView": False,
        "parameterData": False
      }
    }
  },
  "user_role_description": "Operator",
  "user_role_name": "Operator",
  "user_role_permissions": {
    "userManagement": {
      "key": "userManagement",
      "name": "User Management",
      "create": True,
      "delete": True,
      "edit": True,
      "view": True,
      "children": {
        "users": {
          "key": "users",
          "name": "User",
          "create": True,
          "delete": True,
          "edit": True,
          "view": True
        }
      }
    },
    "approvalInbox": {
      "key": "approvalInbox",
      "name": "Approval Inbox",
      "create": True,
      "delete": True,
      "edit": True,
      "view": True
    },
    "artifacts": {
      "key": "artifacts",
      "name": "artifacts",
      "create": True,
      "delete": True,
      "edit": True,
      "view": True
    }
  },
  "catalogPermission": True
}
]

DEFAULT_USER = {
    "encryption_salt": {"dt_0": [], "dt_1": []},
    "name": "CatalogUser",
    "username": "cataloguser",
    "password": "",
    "email": "tarun.madamanchi@rockwellautomation.com",
    "user_type": "catalog_user",
    "phonenumber": 9581388594,
    "userrole": ["user_role_096"],
    "user_id": "user_097",
    "created_by": "user_097",
    "product_encrypted": False,
    "failed_attempts": 0,
    "is_user_locked": False,
    "last_failed_attempt": "2021-05-13 08:56:15",
    "ilens_encrypted": False,
    "passwordReset": None,
    "tz": None,
    "expires_on": "02/12/21 09:00 30 AM",
    "disable_user": False,
    "last_logged_in": 1735796769,
    "last_failed_login": None,
    "fixed_delay": 0,
    "variable_delay": 0,
    "space_id": "space_099",
    "default_user": True,
}


DEFAULT_SPACE = {
    "space_id": "space_099",
    "userrole": ["user_role_096"],
    "created_by": "user_097",
    "updated_time": datetime.utcnow().isoformat() + "Z",  # UTC in ISO-8601 format
    "user_id": "user_097",
    "updated_by": "user_097",
}