import time
from typing import Optional

from pydantic import Field, BaseModel


class CreateWorkspace(BaseModel):
    space_id: str
    space_name: str
    space_type: str
    user_id: str = Field(default="user_097")
    source_meta: Optional[dict] = Field(default={"add_prefix_to_database": False})
    meta: Optional[dict] = Field(default={"created_at": int(time.time())})
    access_token: Optional[str] = Field(default=None)
    catalog_url: Optional[str] = Field(default=None)
