import json

import paho.mqtt.client as mqtt

from scripts.config import MQTTConf
from scripts.logging import logger


def on_connect(rc):
    logger.debug(f"Publisher Connected with result code {str(rc)}")


def push_notification(notification, user_id):
    try:
        client = mqtt.Client()
        client.username_pw_set(MQTTConf.MQTT_USERNAME, MQTTConf.MQTT_PASSWORD)
        client.on_connect = on_connect
        client.connect(MQTTConf.MQTT_HOST, MQTTConf.MQTT_PORT, 30)
        topic = f"{MQTTConf.PUBLISH_BASE_TOPIC}/{user_id}/tasks"
        if not client.is_connected():
            client.reconnect()
        client.publish(topic, json.dumps(notification), retain=False, qos=1)
        logger.info(f"Notification message published to {topic}")
        logger.debug(f"Notification: {notification}")
        client.disconnect()
        return True
    except Exception as e:
        logger.exception(f"Exception at MQTT Publish: {e}")
        return False
