from ut_mongo_util import CollectionBaseClass

from scripts.constants.db_constants import CollectionNames, DatabaseNames


class Widget(CollectionBaseClass):
    def __init__(self, mongo_client, project_id=None):
        super().__init__(
            mongo_client,
            database=DatabaseNames.ilens_widget,
            collection=CollectionNames.collection_widget,
        )
        self.project_id = project_id

    def find_widgets_by_dashboard(self, dashboard_id):
        query = {"dashboard_id": dashboard_id}
        return self.find(query=query)

    def insert_many_widgets(self, data):
        return self.insert_many(data)

    def find_widgets_by_dashboard_ids(self, dashboard_ids):
        query = {"dashboard_id": {"$in": dashboard_ids}}
        filter_dict = {"_id": 0}
        return self.find(query=query, filter_dict=filter_dict)
