from ut_mongo_util import CollectionBaseClass

from scripts.constants.db_constants import CollectionNames, DatabaseNames


class Dashboard(CollectionBaseClass):
    def __init__(self, mongo_client, project_id=None):
        super().__init__(
            mongo_client,
            database=DatabaseNames.ilens_widget,
            collection=CollectionNames.collection_dashboard,
        )
        self.project_id = project_id

    def find_dashboard(self, dashboard_id, project_id=None):
        query = {"dashboard_id": dashboard_id}
        if project_id:
            query.update({"project_id": project_id})
        filter_dict = {"_id": 0}
        return self.find_one(query=query, filter_dict=filter_dict)

    def update_dashboard(self, dashboard_id, data):
        query = {"dashboard_id": dashboard_id}
        return self.update_one(query=query, data=data, upsert=True)

    def find_dashboard_by_ids(self, dashboard_ids, project_id=None):
        query = {"dashboard_id": {"$in": dashboard_ids}}
        if project_id:
            query.update({"project_id": project_id})
        filter_dict = {"_id": 0}
        return self.find(query=query, filter_dict=filter_dict)
