from typing import Optional

from pydantic import BaseModel
from ut_mongo_util import CollectionBaseClass

from scripts.constants.db_constants import CollectionNames, DatabaseNames


class CategorySchema(BaseModel):
    project_id: Optional[str] = ""
    categoryName: Optional[str] = ""
    color: Optional[str] = ""
    dashboard_category_id: Optional[str] = ""


class Category(CollectionBaseClass):
    key_project_id = "project_id"
    key_dashboard_category_id = "dashboard_category_id"
    key_category_name = "categoryName"
    key_category = "category"
    key_color = "color"

    def __init__(self, mongo_client, project_id=None):
        super().__init__(
            mongo_client,
            database=DatabaseNames.ilens_widget,
            collection=CollectionNames.category,
        )
        self.project_id = project_id

    def find_category(self, category_id, project_id=None):
        query = {self.key_dashboard_category_id: category_id}
        if project_id:
            query.update({"project_id": project_id})
        filter_dict = {"_id": 0}
        return self.find_one(query=query, filter_dict=filter_dict)
