from typing import Any, Union

from ut_mongo_util import CollectionBaseClass

from scripts.constants.common_constants import CommonKeys
from scripts.constants.db_constants import CollectionNames, DBConstants


class TempParameters(CollectionBaseClass):
    def __init__(self, mongo_client, project_id=None):
        super().__init__(
            mongo_client,
            database=DBConstants.ilens_configuration,
            collection=CollectionNames.temp_parameters,
        )
        self.project_id = project_id

    @property
    def key_project_id(self):
        return CommonKeys.KEY_PROJECT_ID

    @property
    def key_user_id(self):
        return CommonKeys.KEY_USER_ID

    @property
    def key_id(self):
        return CommonKeys.KEY_ID

    def find_by_project(
        self, project_id: str, projections=None, sort=None, query_dict=None, limit=None, skip=0, **filters
    ) -> Union[Any, None]:
        query = {self.key_project_id: project_id}
        if query_dict:
            query |= query_dict
        if filters:
            query.update(filters)
        records = self.find(query, projections, sort=sort, limit=limit, skip=skip)
        return list(records) if records else None

    def insert_many_parameters(self, data):
        """
        The following function will insert more than one parameters data for temporary use
        :param self:
        :param data:
        :return:
        """
        return self.insert_many(data)

    def delete_many_parameters(self, project_id=None, user_id=None, delete_key=None):
        """
        The following function will delete more than one parameters
        data based on project_id and user_id
        :param self:
        :param project_id:
        :param user_id:
        :param delete_key:
        :return:
        """
        query = {}
        if project_id:
            query[self.key_project_id] = project_id
        if user_id:
            query[self.key_user_id] = user_id
        if delete_key:
            query[delete_key] = True

        return self.delete_many(query)

    def delete_one_parameter(self, project_id, user_id, tag_id=None, temp_id=None):
        """
        The following function will delete one parameter data based on query
        """
        query = {self.key_project_id: project_id, self.key_user_id: user_id}
        if tag_id:
            query[self.key_id] = tag_id
        if temp_id:
            query["temp_id"] = temp_id
        return self.delete_one(query)

    def find_by_aggregate(self, query):
        return list(record) if (record := self.aggregate(query)) else []
