from ut_mongo_util import CollectionBaseClass

from scripts.constants.common_constants import TagKeys
from scripts.constants.db_constants import CollectionNames, DBConstants


class Tags(CollectionBaseClass):
    def __init__(self, mongo_client, project_id=None):
        super().__init__(mongo_client, database=DBConstants.ilens_configuration, collection=CollectionNames.tags)
        self.project_id = project_id

    @property
    def key_tag_id(self):
        return TagKeys.KEY_TAG_ID

    @property
    def key_tag_name(self):
        return TagKeys.KEY_TAG_NAME

    def find_name_by_id(self, tag_id: str):
        query = {self.key_tag_id: tag_id}
        filter_dict = {self.key_tag_name: 1, "_id": 0}
        record = self.find_one(query, filter_dict)
        if not record:
            return None
        return record[self.key_tag_name]

    def find_all_tags(self, sort=None, skip=0, limit=None, **query):
        """
        The following function will give all tags for the given set of
        search parameters as keyword arguments
        :param sort:
        :param skip:
        :param limit:
        :param query:
        :return:
        """
        filter_dict = {"id": 1, "tag_name": 1, "tag_category_name": 1, "tag_category_id": 1, "description": 1, "_id": 0}
        response = self.find(filter_dict=filter_dict, sort=sort, skip=skip, limit=limit, query=query)
        if not response:
            return []
        return list(response)

    def find_tags(self, query):
        all_tags = self.find(query=query)
        if all_tags:
            return list(all_tags)
        return []

    def find_tags_by_aggregate(self, query):
        tags = self.aggregate(query)
        if not tags:
            return []
        return list(tags)

    def insert_one_tag(self, data):
        """
        The following function will insert one tag in the
        tags collections
        :param data:
        :return:
        """
        return self.insert_one(data)

    def insert_many_tags(self, data):
        """
        The following function will insert many tags in the
        tags collection
        :param data:
        :return:
        """
        return self.insert_many(data)
