from typing import Optional

from pydantic import BaseModel
from ut_mongo_util import CollectionBaseClass

from scripts.constants.common_constants import PrivateSpaceKeys
from scripts.constants.db_constants import CollectionNames, DatabaseNames


class PrivateCatalogSpace(BaseModel):
    catalog_space_id: Optional[str] = ""
    catalog_space_name: str
    associated_projects: Optional[list] = []
    space_description: Optional[str] = ""
    created_at: Optional[int] = 0
    created_by: Optional[str] = ""
    updated_at: Optional[int] = 0
    updated_by: Optional[str] = ""
    is_private: bool = True
    approvers: Optional[list] = []


class PrivateCatalogSpaceConn(CollectionBaseClass):
    def __init__(self, mongo_client, project_id=None):
        super().__init__(
            mongo_client, database=DatabaseNames.ilens_configuration, collection=CollectionNames.private_catalog_space
        )
        self.project_id = project_id

    @property
    def key_space_id(self):
        return PrivateSpaceKeys.KEY_CATALOG_SPACE_ID

    @property
    def key_space_name(self):
        return PrivateSpaceKeys.KEY_CATALOG_SPACE_NAME

    def find_name_by_id(self, tag_id: str):
        query = {self.key_space_id: tag_id}
        filter_dict = {self.key_space_name: 1, "_id": 0}
        record = self.find_one(query, filter_dict)
        if not record:
            return None
        return record[self.key_tag_name]

    def find_tags(self, query):
        all_spaces = self.find(query=query)
        if all_spaces:
            return list(all_spaces)
        return []

    def fetch_one_private_space(self, filter_dict=None, **query):
        one_step = self.find_one(filter_dict=filter_dict, query=query)
        return PrivateCatalogSpace(**one_step) or {}

    def update_one_space(self, data, upsert=False, **query):
        """
        The following function will update one step in
        steps collection based on the given query
        :param data:
        :param upsert:
        :param query:
        :return:
        """
        return self.update_one(data=data, upsert=upsert, query=query)

    def get_data_by_aggregate(self, query_json: list):
        return list(self.aggregate(query_json))

    def soft_delete_space(self, catalog_space_id):
        json_update = {"is_deleted": True}
        query = {self.key_space_id: catalog_space_id}
        return self.update_many(data=json_update, query=query)
