from pydantic import BaseModel
from ut_mongo_util import CollectionBaseClass

from scripts.constants.db_constants import CollectionNames, DatabaseNames


class PipelineInfoSchema(BaseModel):
    """
    This is the Schema for the Mongo DB Collection.
    All datastore and general responses will be following the schema.
    """


class PipelineInfo(CollectionBaseClass):
    def __init__(self, mongo_client, project_id):
        super().__init__(
            mongo_client, database=DatabaseNames.ilens_configuration, collection=CollectionNames.pipeline_info
        )
        self.project_id = project_id
