from typing import Optional

from pydantic import BaseModel
from ut_mongo_util import CollectionBaseClass

from scripts.constants.db_constants import CollectionNames, DatabaseNames


class JobListSchema(BaseModel):
    job_id: str
    status: Optional[str] = ""
    project_id: Optional[str] = ""
    job_name: Optional[str] = ""
    custom_node_id: Optional[str] = ""
    start_time: Optional[float] = None
    end_time: Optional[str] = ""
    owner: Optional[str] = ""
    job_type: Optional[str] = ""
    action: Optional[str] = ""
    remark: Optional[str] = ""


class JobLists(CollectionBaseClass):
    def __init__(self, mongo_client):
        super().__init__(mongo_client, database=DatabaseNames.ilens_configuration, collection=CollectionNames.job_list)

    @property
    def key_job_id(self):
        return "job_id"
