from ut_mongo_util import CollectionBaseClass

from scripts.constants.db_constants import CollectionNames, DatabaseNames


class Header(CollectionBaseClass):
    def __init__(self, mongo_client, project_id=None):
        super().__init__(mongo_client, database=DatabaseNames.ilens_configuration, collection=CollectionNames.header)
        self.project_id = project_id

    def find_by_header_id(self, header_id):
        _headerId = header_id
        _return = {}

        _response = self.find_one(query={"header_id": _headerId}, filter_dict={"_id": 0})
        if _response:
            _return = _response
        return _return

    def update_by_id(self, header_id, data):
        _result = self.update_one(query={"header_id": header_id}, data=data)
        if _result:
            return True
        return False
