from typing import Dict, Optional

from pydantic import BaseModel
from ut_mongo_util import CollectionBaseClass

from scripts.constants.db_constants import (
    CollectionNames,
    CustomerProjectKeys,
    DatabaseNames,
)


class CustomerProjectsSchema(BaseModel):
    """
    This is the Schema for the Mongo DB Collection.
    All datastore and general responses will be following the schema.
    """

    customer_project_name: Optional[str] = None
    description: Optional[str] = None
    site_templt_id: Optional[str] = None
    logo_name: Optional[str] = None
    logo_url: Optional[str] = None
    process_templt_id: Optional[str] = None
    update_details: Optional[Dict] = None
    user_id: Optional[str] = None
    customer_project_id: Optional[str] = None
    product_encrypted: Optional[bool] = None
    project_type: Optional[str] = None


class CustomerSpaces(CollectionBaseClass):
    def __init__(self, mongo_client):
        super().__init__(
            mongo_client, database=DatabaseNames.ilens_configuration, collection=CollectionNames.customer_space
        )

    @property
    def key_customer_project_id(self):
        return CustomerProjectKeys.KEY_CUSTOMER_PROJECT_ID

    @property
    def key_customer_project_name(self):
        return CustomerProjectKeys.KEY_CUSTOMER_PROJECT_NAME

    def find_project(self, project_id=None, project_name=None, filter_dict=None):
        """
        The following function will give one record for a given set of
        search parameters as keyword arguments
        :param project_name:
        :param filter_dict:
        :param project_id:
        :return:
        """
        query = {}
        if project_id:
            query.update({self.key_customer_project_id: project_id})
        if project_name:
            query.update({self.key_customer_project_name: project_name})
        record = self.find_one(query=query, filter_dict=filter_dict)
        if not record:
            return {}
        return CustomerProjectsSchema(**record).dict()

    def find_project_by_query(self, query, filter_dict=None):
        record = self.find(query=query, filter_dict=filter_dict)
        if record:
            return record
        return []

    def fetch_project_details(self):
        query = {}
        filter_dict = {self.key_customer_project_id: 1, "_id": 0, self.key_customer_project_name: 1}
        records = self.find(query=query, filter_dict=filter_dict)
        if records:
            project_name_mapp = {}
            for record in records:
                project_name_mapp[record.get(self.key_customer_project_id)] = record.get(self.key_customer_project_name)
            return project_name_mapp
        return {}

    def insert_one_project(self, data):
        """
        The following function will insert one project in the
        customer_projects collections
        :param self:
        :param data:
        :return:
        """
        return self.insert_one(data)

    def update_one_project(self, project_id, data):
        query = {self.key_customer_project_id: project_id}
        return self.update_one(query=query, data=data)

    def delete_one_project(self, project_id):
        if project_id:
            query = {self.key_customer_project_id: project_id}
            return self.delete_one(query)
        else:
            return False

    def get_project_data_by_aggregate(self, query: list):
        return list(self.aggregate(pipelines=query))
