from ut_mongo_util import CollectionBaseClass

from scripts.constants.db_constants import CollectionNames, DBConstants


class CustomerApps(CollectionBaseClass):
    def __init__(self, mongo_client, project_id=None):
        super().__init__(
            mongo_client, database=DBConstants.ilens_configuration, collection=CollectionNames.customer_apps
        )
        self.project_id = project_id

    def find_app_by_project(self, project_id, filter_dict=None, sort_starred=False):
        query = {"project_id": project_id}
        sort_query = [("starred", -1)] if sort_starred else None
        record = self.find(query=query, filter_dict=filter_dict, sort=sort_query)
        return record or []
