from pydantic import BaseModel
from ut_mongo_util import CollectionBaseClass

from scripts.constants.db_constants import CollectionNames, DatabaseNames


class CustomNodeSchema(BaseModel):
    """
    This is the Schema for the Mongo DB Collection.
    All datastore and general responses will be following the schema.
    """


class CustomNode(CollectionBaseClass):
    def __init__(self, mongo_client, project_id=None):
        super().__init__(
            mongo_client, database=DatabaseNames.ilens_configuration, collection=CollectionNames.custom_node
        )
        self.project_id = project_id

    def find_all_by_id(self, category_id):
        _return = []
        _category_id = category_id

        _query = {"category_id": _category_id}
        _response = self.find(query=_query, filter_dict={"_id": 0})

        if _response:
            _return = list(_response)
        return _return
