from ut_mongo_util import CollectionBaseClass

from scripts.constants.db_constants import CollectionNames, DBConstants


class CategoryApps(CollectionBaseClass):
    def __init__(self, mongo_client, project_id=None):
        super().__init__(
            mongo_client, database=DBConstants.ilens_configuration, collection=CollectionNames.category_apps
        )
        self.project_id = project_id

    def find_app_category_by_project(self, project_id, filter_dict=None):
        query = {"project_id": project_id}
        record = self.find(query=query, filter_dict=filter_dict)
        return record or []
