from typing import List, Optional

from pydantic import BaseModel
from ut_mongo_util import CollectionBaseClass

from scripts.constants.db_constants import CollectionNames, DatabaseNames


class AIModelSchema(BaseModel):
    ai_model_id: str
    label: Optional[str] = ""
    description: Optional[str] = ""
    img: Optional[List] = []


class AIModel(CollectionBaseClass):
    def __init__(self, mongo_client, project_id=None):
        super().__init__(mongo_client, database=DatabaseNames.global_catalog, collection=CollectionNames.ai_models)
        self.project_id = project_id

    def find_all(self, project_id):
        records = self.find({"project_id": project_id})
        if not records:
            return []
        return list(records)

    def get_data_by_aggregate(self, query_json: list):
        return list(self.aggregate(query_json))
