from scripts.constants.db_constants import AggregationKeys


class UsersAggregate:
    @staticmethod
    def get_users_list(project_id=None):
        query_json = [
            {
                "$project": {
                    "user_id": AggregationKeys.user_id,
                    "username": AggregationKeys.username,
                    "userName": {"$toLower": AggregationKeys.username},
                }
            },
            {"$sort": {"userName": 1}},
            {
                AggregationKeys.group: {
                    "_id": None,
                    "data": {
                        AggregationKeys.push: {
                            "k": {AggregationKeys.ifnull: [AggregationKeys.user_id, ""]},
                            "v": {AggregationKeys.ifnull: [AggregationKeys.username, ""]},
                        }
                    },
                }
            },
            {AggregationKeys.replace_root: {"newRoot": {AggregationKeys.arraytoobject: AggregationKeys.data}}},
        ]
        if bool(project_id):
            query_json.insert(0, {AggregationKeys.match: {"project_id": project_id}})
        return query_json

    @staticmethod
    def get_users_value_pairs(project_id=None):
        query_json = [
            {
                AggregationKeys.group: {
                    "_id": None,
                    "data": {
                        AggregationKeys.push: {
                            "v": {AggregationKeys.ifnull: [AggregationKeys.user_id, ""]},
                            "k": {AggregationKeys.ifnull: [AggregationKeys.username, ""]},
                        }
                    },
                }
            },
            {AggregationKeys.replace_root: {"newRoot": {AggregationKeys.arraytoobject: AggregationKeys.data}}},
        ]
        if bool(project_id):
            query_json.insert(0, {AggregationKeys.match: {"project_id": project_id}})
        return query_json

    @staticmethod
    def get_users_list_aggregate(project_id=None):
        query_json = [
            {
                AggregationKeys.group: {
                    "_id": None,
                    "data": {
                        AggregationKeys.push: {
                            "k": {"$ifNull": ["$user_id", ""]},
                            "v": {"$ifNull": ["$username", ""]},
                        }
                    },
                }
            },
            {AggregationKeys.replace_root: {"newRoot": {AggregationKeys.arraytoobject: AggregationKeys.data}}},
        ]
        if bool(project_id):
            query_json.insert(0, {AggregationKeys.match: {"project_id": project_id}})
        return query_json
