from scripts.constants.db_constants import (
    AggregationKeys,
)


class CustomNodeAggregate:
    @staticmethod
    def fetch_custom_nodes(query_data, filters=None, filter_key=False):
        project_id = query_data.get("project_id")
        counter = int(query_data.get("counter")) if query_data.get("counter") else 1
        records = int(query_data.get("records")) if query_data.get("records") else 10
        skip = (counter - 1) * records
        query = [
            {AggregationKeys.match: {"project_id": project_id}},
            {"$group": {"_id": "$custom_node_id", "value": {"$sum": 1}, "name": {"$push": "$$ROOT"}}},
            {AggregationKeys.sort: {"value": -1}},
            {AggregationKeys.project: {"name": {"$arrayElemAt": [AggregationKeys.name, {"$subtract": ["$value", 1]}]}}},
            {"$replaceRoot": {"newRoot": AggregationKeys.name}},
            {"$skip": skip},
            {"$limit": records},
            {AggregationKeys.project: {"_id": 0}},
        ]
        if filter_key:
            search_query = {
                "$or": [{"node_name": {AggregationKeys.regex: filters["search"], AggregationKeys.options: "i"}}]
            }
            query.insert(6, {AggregationKeys.match: search_query})
            if filters.get("sort_by"):
                sort_value = 1 if filters["sort_by"] == "asc" else -1
                sort_query = {"node_name": sort_value}
                query.insert(7, {AggregationKeys.sort: sort_query})

        return query

    @staticmethod
    def fetch_custom_node_count(project_id, filters=None, filter_key=False):
        query = [
            {AggregationKeys.match: {"project_id": project_id}},
            {"$group": {"_id": "$custom_node_id", "value": {"$sum": 1}, "name": {"$push": "$$ROOT"}}},
            {AggregationKeys.sort: {"value": -1}},
            {AggregationKeys.project: {"name": {"$arrayElemAt": [AggregationKeys.name, {"$subtract": ["$value", 1]}]}}},
            {"$replaceRoot": {"newRoot": AggregationKeys.name}},
            {"$count": "count"},
        ]
        if filter_key:
            if filters.get("search"):
                search_query = {
                    "$or": [
                        {
                            "node_name": {
                                AggregationKeys.regex: filters["search"],
                                AggregationKeys.options: "i",
                            }
                        }
                    ]
                }
            else:
                search_query = {"$or": [{"node_name": {AggregationKeys.regex: "", AggregationKeys.options: "i"}}]}
            query.insert(6, {AggregationKeys.match: search_query})
        return query
