from scripts.constants.db_constants import AggregationKeys


class CustomAppsAggregate:
    @staticmethod
    def get_apps(project_id, counter, records, filters=None):
        skip = (counter - 1) * records
        query = [
            {
                AggregationKeys.lookup: {
                    "from": "category_apps",
                    "localField": "app_category_id",
                    "foreignField": "app_category_id",
                    "as": "app_category_details",
                }
            },
            {AggregationKeys.match: {"project_id": project_id}},
            {"$project": {"_id": 0}},
            {"$skip": skip},
            {"$limit": records},
        ]

        if filters.get("search"):
            search_query = {
                "$or": [
                    {"app_name": {AggregationKeys.regex: filters["search"], AggregationKeys.options: "i"}},
                    {
                        "description": {
                            AggregationKeys.regex: filters["search"],
                            AggregationKeys.options: "i",
                        }
                    },
                ]
            }
        else:
            search_query = {
                "$or": [
                    {"app_name": {AggregationKeys.regex: "", AggregationKeys.options: "i"}},
                    {"description": {AggregationKeys.regex: "", AggregationKeys.options: "i"}},
                ]
            }
        query.insert(6, {AggregationKeys.match: search_query})
        return query

    @staticmethod
    def get_all_apps(project_id):
        return [
            {
                AggregationKeys.lookup: {
                    "from": "category_apps",
                    "localField": "app_category_id",
                    "foreignField": "app_category_id",
                    "as": "app_category_details",
                }
            },
            {AggregationKeys.match: {"project_id": project_id}},
            {"$project": {"_id": 0}},
        ]

    @staticmethod
    def get_app_details(app_id, project_id):
        aggregate_qry = [
            {
                AggregationKeys.lookup: {
                    "from": "category_apps",
                    "localField": "app_category_id",
                    "foreignField": "app_category_id",
                    "as": "app_category_details",
                }
            },
            {AggregationKeys.match: {"app_id": app_id, "project_id": project_id}},
        ]
        return aggregate_qry
