from scripts.constants.db_constants import AggregationKeys


class ConstantsAggregate:
    resources_thumbnail = [
        {AggregationKeys.match: {"type": "resources_thumbnail"}},
        {"$unwind": "$data"},
        {"$group": {"_id": None, "file_type": {"$push": {"k": "$data.file_type", "v": "$data.image_string"}}}},
        {"$project": {"_id": 0, "file_type": {"$arrayToObject": "$file_type"}}},
    ]

    @staticmethod
    def site_template_details(site_template_id):
        query = [
            {AggregationKeys.match: {"type": "site_template"}},
            {"$unwind": "$data"},
            {AggregationKeys.match: {"data.site_templt_id": site_template_id}},
            {"$project": {"_id": 0, "hierarchy_value": "$data.value", "hierarchy_key": "$data.key_list"}},
        ]
        return query
