import re

from scripts.constants.db_constants import AggregationKeys


class AIModelAggregation:
    @staticmethod
    def ai_model_list_aggregation(project_id, filters=None):
        query = [
            {AggregationKeys.match: {"project_id": project_id}},
            {
                "$project": {
                    "_id": 0,
                    "project_id": "$project_id",
                    "label": "$label",
                    "description": "$description",
                    "ai_model_id": "$ai_model_id",
                }
            },
        ]
        if filters:
            match_filter = {"label": {AggregationKeys.regex: re.escape(filters.get("search", "")), "$options": "i"}}
            query[0][AggregationKeys.match].update(match_filter)
        return query
