import os


class UserRoles:
    root_user = "root_user"
    super_user = "kl_super_admin"
    GLOBAL_CATALOG_USER_TYPE = "catalog_user"
    required_keys = [
        each_key.strip()
        for each_key in os.environ.get(
            "USER_ROLE_KEYS",
            default="edit, create, view, publish, delete, "
            "clone, share,attachLicense, operator,"
            "auditLogs, screenshotRestriction, dashboard, title, auditLogsDownload, attachLicense, feedback, "
            "uploadLicense",
        ).split(",")
    ]

    user_id = "user_id"
    username = "username"
    email = "email"
    name = "name"
    userrole = "userrole"
    access_group = "access_group"
    access_group_ids = "access_group_ids"
    access_group_id = "access_group_id"
    access_list = "access_list"
    description = "description"
    height = "calc(100vh - 200px)"
    access_list_action = [
        {"label": "Edit", "type": "edit", "action": "edit"},
        {"label": "Delete", "type": "delete", "action": "delete"},
    ]
    remove_action = [
        {
            "label": "Remove",
            "type": "remove",
            "action": "remove",
            "icon-class": "fa fa-minus-circle",
        }
    ]
    add_existing_action = [
        {
            "label": "Add existing",
            "type": "addnew",
            "action": "addexisting",
            "custom_class": "btn-secondary",
        }
    ]
    user_download_option = [{"label": "", "type": "download", "action": "download"}]
    access_list_external_action = [
        {"label": "Create New", "type": "button", "action": "addnew", "icon_class": "fa fa-plus-circle"},
    ]
    access_list_header_content = [
        {"label": "Access Group", "key": "access_group"},
        {"label": "Description", "key": "description"},
    ]
    list_all_user_header = [
        {
            "label": "iLens ID",
            "key": "username",
            "tooltip": "status_info",
            "type": "icon",
            "value_position": "right",
            "iconClass": "status_icon",
            "enable_value_disp": True,
            "enableTooltip": True,
            "header_type": "text",
            "options": [],
            "enable_column_search": True,
        },
        {
            "label": "Full Name",
            "key": "full_name",
            "header_type": "text",
            "options": [],
            "enable_column_search": True,
        },
        {
            "label": "Email",
            "key": "e_mail",
            "header_type": "text",
            "options": [],
            "enable_column_search": True,
        },
        {
            "label": "Role",
            "key": "role",
            "header_type": "select",
            "options": [],
            "enable_column_search": True,
        },
        {
            "label": "Access Group",
            "key": "access_group",
            "header_type": "select",
            "options": [],
            "enable_column_search": True,
        },
        {
            "label": "Created On",
            "key": "created_on",
            "header_type": "text",
            "options": [],
            "enable_column_search": False,
        },
        {
            "label": "Last Login",
            "key": "last_logged_in",
            "header_type": "text",
            "options": [],
            "enable_column_search": False,
        },
    ]
    user_details_header = [
        {"key": "name", "label": "Name"},
        {"key": "username", "label": "User Name"},
        {"key": "email", "label": "Email"},
        {"key": "phonenumber", "label": "Phone Number"},
        {"key": "userrole", "label": "User Role"},
        {"key": "created_by", "label": "Created By"},
        {"label": "Department", "key": "department"},
        {"label": "Section", "key": "section"},
        {"label": "Location", "key": "location"},
    ]
    external_user_header = [
        {"key": "username", "label": "Existing User"},
        {"key": "userrole", "label": "User Role"},
        {"key": "created_by", "label": "Created By"},
        {"label": "Department", "key": "department"},
        {"label": "Section", "key": "section"},
        {"label": "Location", "key": "location"},
    ]
    user_role_name = "user_role_name"
    user_role_description = "user_role_description"
    user_role_id = "user_role_id"
    user_role_header = [
        {"headerName": "Role", "field": "role"},
        {"headerName": "Description", "field": "description"},
    ]
