import os


class AppSpec:
    name = "ftdm-catalog"
    summary = """A module which manages catalog spaces and responsible for reviewal and approval of
              items which is publishing to catalog"""
    description = """## Overview

This microservice handles the creation and management of catalog spaces, supporting both private and public spaces.
It facilitates the submission of dashboards, apps, and assets to the catalog, where they await review and approval by
 designated approvers in both private and public spaces. Once approved, the content can be published. Additionally,
 the service enables cloning of published content across different projects, allowing connection to both private and
 public spaces to access and duplicate previously published items.

"""


STARTING_VALUE_ERROR = "Input Field-Value shouldn't start with a Special Character.."
STRING_VALUE_ERROR = "Input Field Consists of Unsupported Special Character..."
STARTING_VALIDATION = set(os.environ.get("STRING_VALIDATION_LIST1", default="=,<,+,!,@").split(","))
STRING_VALIDATION = set(os.environ.get("STRING_VALIDATION_LIST2", default="<").split(","))

WEBAPP_CONSTANTS = ["webapp_constants", "app_version"]


class KEYS:
    cookie_encryption_private_key = "#ilenskey@rock1#"
    captcha_cookie_encryption_key = "UnifyTwin@r@ck1$"


class MongoConstants:
    mongo_push_stage = "$push"
    mongo_group_stage = "$group"
    mongo_null_stage = "$ifNull"
    mongo_project_stage = "$project"
    mongo_match_stage = "$match"
    mongo_option_stage = "$options"
    mongo_regex_stage = "$regex"
    access_group_id_mongo = "$access_group_id"
    array_to_object_mongo = "$arrayToObject"


class Secrets:
    LOCK_OUT_TIME_MINS = 30
    leeway_in_mins = 10
    unique_key = "45c37939-0f75"
    token = "8674cd1d-2578-4a62-8ab7-d3ee5f9a"
    issuer = "ilens"
    alg = "RS256"
    SECRET_FOR_SUPPORT_LENS = "WeSupport24X7UnifyTwinX#"
    ISS = "unifytwin"
    AUD = "supportlens"
    signature_key = "kliLensKLiLensKL"
    signature_key_alg = ["HS256"]


class CommonKeys:
    KEY_SHARED_GROUP = "shared_group"
    KEY_SHARED_USER = "shared_user"
    KEY_USER_DETAILS = "user_details"
    KEY_SHARING_INFO = "sharing_info"
    KEY_LAST_UPDATED_TIME = "lastUpdatedTime"
    KEY_LAST_FAILED_ATTEMPT = "last_failed_attempt"
    KEY_USER_ID = "user_id"
    KEY_PROCESS_TEMPLATE = "process_template"
    KEY_SITE_TEMPLATE = "site_template"
    KEY_PROCESS_TEMPLT_ID = "process_templt_id"
    KEY_KEY_LIST = "key_list"
    HIERARCHY_ACCESS_KEY_LIST = "access_key_list"
    KEY_VALUE = "value"
    KEY_SITE_TEMPLT_ID = "site_templt_id"
    KEY_TYPE = "type"
    KEY_PROJECT_ID = "project_id"
    KEY_NAME = "name"
    KEY_CREATED_BY = "created_by"
    KEY_CREATED_ON = "created_on"
    KEY_CUSTOMER_PROJ_ID = "customer_project_id"
    KEY_CONTENT_TYPE = "content_type"
    KEY_UPDATED_BY = "updated_by"
    KEY_UPDATED_ON = "updated_on"
    KEY_MACHINE_BUILDER_PROJECT = "machine_builder"
    KEY_CUSTOMER_PROJECT = "customer"
    KEY_N_LEVEL_HIERARCHY_PROJECT = "n_level_hierarchy"
    KEY_GRAPH_MODEL = "graph_model"
    KEY_MACHINE_BUILDER_LABEL = "Machine Builder Project"
    KEY_CUSTOMER_PROJECT_LABEL = "Customer Project - Fixed Level Hierarchy"
    KEY_N_LEVEL_HIERARCHY_LABEL = "Customer Project - N Level Hierarchy"
    KEY_GATEWAY_TYPE = "line"
    KEY_SENSOR_TYPE = "equipment"
    KEY_CATEGORY_NAME = "categoryName"
    KEY_DASHBOARD_CATEGORY_ID = "dashboard_category_id"
    KEY_CREATE_NEW = "Create New"
    KEY_ACTIVITY_NAME = "Activity Name"
    KEY_ZIP_CODE = "Zip Code"
    KEY_MAKE_MODEL = "Make & Model"
    KEY_MACHINE_ID_EQUIPMENT_CODE = "Machine ID/ Equipment Code"
    KEY_ALREADY_EXIST = "Already Exist"
    KEY_STAGING_URL_OBJECT_DETECTION = "https://staging.ilens.io/ilens-manager/#/p/apps/object-detection"
    KEY_INVENTORY_WAREHOUSE = ("Inventory by Warehouse",)
    KEY_ASIA_KOLKATA = "Asia/Kolkata"
    KEY_REGEX = "$regex"
    KEY_OPTIONS = "$options"
    KEY_TARGET_HEADER_ID = "target_configuration"
    KEY_HEADER_ID = "header_id"
    KEY_LEVEL = "level"
    LEVEL_KEY = "level_key"
    KEY_DESCRIPTION = "description"
    KEY_SUB_CATEGORY_NAME = "sub_category_name"
    TYPE = "type"
    KEY_EMAIL_ID = "email"
    KEY_APPROVED = "approved"
    KEY_REJECT = "rejected"
    KEY_REVIEW_PENDING = "review_pending"
    KEY_ISDEL = "isdeleted"
    STD_TIME_ZONE = "Asia/Kolkata"
    category = "dashboard_category_099"
    under_review_json = {"type": "switch", "key": "under_review", "filterLabel": "Show Review Pending Items only."}
    KEY_PUSH = "$push"
    KEY_SORT = "$sort"
    KEY_ARRAY_ELEMENT = "$arrayElemAt"
    KEY_VALUE_MONGO = "$value"
    KEY_PROJECT = "$project"
    KEY_MATCH = "$match"
    KEY_EXISTS = "$exists"
    KEY_GROUP = "$group"
    KEY_ACCESS_GRP = "access_group"
    KEY_ACCESS_GRP_ID = "access_group_id"
    KEY_ACCESS_GRP_IDS = "access_group_ids"
    KEY_AI_RULE_ID = "rule_id"
    KEY_AI_RULE_INFO = "rule_info"
    KEY_AI_RULE_NAME = "rule_name"
    KEY_CATEGORY = "category"
    KEY_CREATED_TIME = "created_at"
    KEY_COMPLETED_AT = "completed_at"
    KEY_UPDATED_AT = "updated_by"
    KEY_DASHBOARD_ID = "dashboard_id"
    KEY_DASHBOARD_TYPE = "dashboard_type"
    KEY_DATA = "data"
    KEY_ENABLE_DELETE = "enable_delete"
    KEY_ENABLE_EDIT = "enable_edit"
    KEY_FEATURE_ADDITION = "feature_addition"
    KEY_FROM_DATE = "from_date"
    KEY_FROM_TIME = "from_time"
    KEY_ID = "id"
    KEY_IS_DEL = "is_deleted"
    KEY_IS_OWNER = "isOwner"
    KEY_KEYS = "keys"
    KEY_MESSAGE = "message"
    KEY_META = "meta"
    KEY_MONGO_ID = "_id"
    KEY_OWNER = "owner"
    KEY_RECORDS = "records"
    KEY_STARRED = "starred"
    KEY_STATUS = "status"
    KEY_TIME_RANGE = "timeRange"
    KEY_TO_DATE = "to_date"
    KEY_TO_TIME = "to_time"
    KEY_USER = "user"
    KEY_USERS = "users"
    KEY_USER_DETAILS_CC = "userDetails"
    KEY_USER_NAME = "username"
    KEY_USER_TZ = "user_tz"
    KEY_V_DEVICE = "virtual_device_id"
    KEY_WIDGET_DATA = "widget_data"
    KEY_WIDGET_ID = "widget_id"
    KEY_WIDGET_ORDER = "widget_order"
    KEY_WIDGET_TYPE = "widget_type"
    KEY_COMMENTS = "comments"
    KEY_WIDGET_COMMENT = "widget_comment"
    KEY_CHAINED_USER_GROUP_ID = "sharing_info.userGroups.id"


class DateConstants:
    date_format = "%d %b %Y %H:%M"


class ButtonConstants:
    button_text_success = "fa fa-check-circle-o text-success"
    button_text_danger = "fa fa-ban text-danger"
    in_active = "In active"


class CaptchaKeys:
    max_length = 5
