import json

import httpx

from scripts.config import Service
from scripts.logging import logger


def fetch_and_update_gc_login_token():
    headers = {"auth-token": Service.GC_BEARER_TOKEN}
    params = {
        "project_id": Service.GLOBAL_CATALOG_PROJECT_ID,
        "user_id": Service.GLOBAL_CATALOG_USER,
        "age": 60,
    }
    global_workflow_data_url = f"{Service.GLOBAL_CATALOG_SERVICES}/ilens_api/ilens_config/gc/login"
    logger.info(f"catalog_create_url url {global_workflow_data_url}")
    with httpx.Client() as client:
        login_token = client.get(url=global_workflow_data_url, params=params, headers=headers, timeout=Service.TIMEOUT)
    if login_token.status_code == 200:
        logger.info(f"login_token: {json.loads(login_token.text)}")
        login_token = json.loads(login_token.text)
        logger.info("Adding login token to app configuration")
        Service.GLOBAL_CATALOG_TOKEN = login_token
    else:
        logger.error(f"Internal Server Error: {login_token.status_code}")
