import gc
import os

from apscheduler.schedulers.asyncio import AsyncIOScheduler
from dotenv import load_dotenv
from pytz import utc
from ut_security_util import FastAPIConfig, generate_fastapi_app

from scripts.background import fetch_and_update_gc_login_token
from scripts.config import Service
from scripts.constants import AppSpec
from scripts.logging import logger
from scripts.services import router

load_dotenv()

secure_access = os.environ.get("SECURE_ACCESS", default=False)

gc.collect()

Schedule = None


app_config = FastAPIConfig(
    title=AppSpec.name,
    version="V1",
    description=AppSpec.description,
    root_path="/catalog-management",
    redoc_url="/redoc",
)
app = generate_fastapi_app(
    app_config=app_config,
    routers=[router],
    project_name=Service.APP_NAME,
    enable_default_openapi=True,
    disable_operation_default=True,
)


@app.on_event("startup")
async def startup_event():
    global Schedule
    try:
        Schedule = AsyncIOScheduler()
        Schedule.configure(timezone=utc)
        fetch_and_update_gc_login_token()
        Schedule.add_job(fetch_and_update_gc_login_token, trigger="interval", minutes=30, misfire_grace_time=180)
        Schedule.start()
        logger.info("Created a schedule job to fetch and update global catalog login token in every 30 minutes.")

    except Exception as e:
        logger.error(e)
        logger.error("Unable to create schedule job for fetching and updating global catalog login token.")
