import logging
from pymongo import MongoClient
import time
import shutil
from dotenv import load_dotenv
import os
import json
load_dotenv()
import sys
import httpx

root_path = os.getcwd()
print(f'ROOT PATH ---> {root_path}')
sys.path.append(root_path)

MONGO_URI = os.environ.get("MONGO_URI")
BASE_URI = os.environ.get("BASE_URI")
LOGIN_TOKEN = os.environ.get("LOGIN_TOKEN")
USER_ID = os.environ.get("USER_ID")
PROJECT_ID = os.environ.get("PROJECT_ID")
APP_NAME = os.environ.get("APP_NAME")
PREFIX = os.environ.get("PREFIX")
BASE_PATH = os.environ.get("BASE_PATH")
MOUNT_DIR = os.environ.get("MOUNT_DIR")


client = MongoClient(MONGO_URI)
logging.basicConfig(level=logging.DEBUG,  # Set the minimum logging level
                    format='%(asctime)s - %(name)s - %(levelname)s - %(message)s')

app_image_url = f"{BASE_URI}ilens_api/ilens_config/get_app_image?type="
dashboard_image_url = f"{BASE_URI}visual4.0/dashboard/snap_dashboard?dashboard_id="

cookie = {"login-token": LOGIN_TOKEN, "userId": USER_ID, "projectId": PROJECT_ID}


class Database:
    def __init__(self, prefix=None):
        self.assistant = client[f"{prefix}__ilens_assistant"] if prefix else client["ilens_assistant"]
        self.configuration = client[f"{prefix}__ilens_configuration"] if prefix else client["ilens_configuration"]
        self.widget = client[f"{prefix}__ilens_widget"] if prefix else client["ilens_widget"]


class Connection(Database):
    def __init__(self, prefix=None):
        super().__init__(prefix)
        self.dashboard = self.widget["dashboard"]
        self.customer_apps = self.configuration["customer_apps"]
        self.lookup_table = self.configuration["lookup_table"]
        self.category_apps = self.configuration["category_apps"]
        self.dashboard_category = self.widget["category"]
        self.widget_col = self.widget["widget"]


def iterate_through_children_mapping(each_children_obj, required_ids, required_type):
    if not each_children_obj.get("children", []):
        view_item = each_children_obj.get("view_item", {})
        if view_item:
            required_id = view_item.get(required_type, None)
            if required_id:
                required_json = {
                    "name": view_item.get("name", None),
                    required_type: view_item.get(required_type, None),
                    "type": view_item.get("module", None),
                }
                if required_type == "dashboard_id":
                    required_json["type"] = "visualization"
                    required_json["categoryName"] = view_item.get("categoryName", None)
                    required_json["dashboard_type"] = view_item.get("dashboard_type", None)
                required_ids.append(required_json)
        hierarchy_stepper = each_children_obj.get("hierarchyStepper", [])
        if hierarchy_stepper:
            for each_hierarchy_stepper in hierarchy_stepper:
                iterate_through_children_mapping(each_hierarchy_stepper, required_ids, required_type)
        return required_ids
    else:
        for each_child in each_children_obj.get("children", []):
            iterate_through_children_mapping(each_child, required_ids, required_type)
        hierarchy_stepper = each_children_obj.get("hierarchyStepper", [])
        if hierarchy_stepper:
            for each_hierarchy_stepper in hierarchy_stepper:
                iterate_through_children_mapping(each_hierarchy_stepper, required_ids, required_type)
    return required_ids


def iterate_through_children(each_children_obj, required_ids, required_type):
    if not each_children_obj.get("children", []):
        if required_type == "module":
            required_id = each_children_obj.get(required_type, None)
            if required_id:
                required_ids.append(required_id)
        else:
            view_item = each_children_obj.get("view_item", {})
            if view_item:
                required_id = view_item.get(required_type, None)
                if required_id:
                    required_ids.append(required_id)
            hierarchy_stepper = each_children_obj.get("hierarchyStepper", [])
            if hierarchy_stepper:
                for each_hierarchy_stepper in hierarchy_stepper:
                    iterate_through_children(each_hierarchy_stepper, required_ids, required_type)
        return required_ids
    else:
        for each_child in each_children_obj.get("children", []):
            iterate_through_children(each_child, required_ids, required_type)
        hierarchy_stepper = each_children_obj.get("hierarchyStepper", [])
        if hierarchy_stepper:
            for each_hierarchy_stepper in hierarchy_stepper:
                iterate_through_children_mapping(each_hierarchy_stepper, required_ids, required_type)
    return required_ids


def dashboard_ids_fetch(children_data):
    module_ids = []
    for each_children in children_data:
        module_ids = iterate_through_children(each_children, module_ids, "dashboard_id")
    return module_ids


def dashboard_categories_zip(dashboard_category_ids, folder_path, prefix=None):
    connection = Connection(prefix=prefix)
    database = Database(prefix=prefix)
    dashboard_category_details = list(
        connection.dashboard_category.find(
            {"dashboard_category_id": {"$in": dashboard_category_ids}, "project_id": prefix}, {"_id": 0}
        )
    )
    dashboard_category_folder = f"{database.widget.name}.category"
    dashboard_category_data_folder_path = os.path.join(folder_path, dashboard_category_folder)
    os.makedirs(dashboard_category_data_folder_path)
    app_data_file_path = os.path.join(dashboard_category_data_folder_path, f"{dashboard_category_folder}.json")
    with open(app_data_file_path, 'w') as file:
        json.dump(dashboard_category_details, file)
        file.close()


def dashboard_zip(dashboard_ids, folder_path, prefix=None):
    connection = Connection(prefix=prefix)
    database = Database(prefix=prefix)
    dashboard_details = list(
                connection.dashboard.find(
                    {"dashboard_id": {"$in": dashboard_ids}, "project_id": prefix}, {"_id": 0}
                )
            )
    widget_ids, dashboard_categories_list = [], []
    for dashboard in dashboard_details:
        widget_ids.extend(dashboard.get("widget_order"))
        dashboard_categories_list.append(dashboard.get("category"))
    dashboard_categories_zip(dashboard_categories_list, folder_path, prefix)
    dashboard_folder = f"{database.widget.name}.dashboard"
    dashboard_data_folder_path = os.path.join(folder_path, dashboard_folder)
    os.makedirs(dashboard_data_folder_path)
    app_data_file_path = os.path.join(dashboard_data_folder_path, f"{dashboard_folder}.json")
    with open(app_data_file_path, 'w') as file:
        json.dump(dashboard_details, file)
        file.close()
    return list(set(widget_ids))


def widget_zip(widget_ids, folder_path, prefix=None):
    connection = Connection(prefix=prefix)
    database = Database(prefix=prefix)
    widget_details = list(
                connection.widget_col.find(
                    {"widget_id": {"$in": widget_ids}, "project_id": prefix}, {"_id": 0}
                )
            )
    widget_folder = f"{database.widget.name}.widget"
    widget_data_folder_path = os.path.join(folder_path, widget_folder)
    os.makedirs(widget_data_folder_path)
    app_data_file_path = os.path.join(widget_data_folder_path, f"{widget_folder}.json")
    with open(app_data_file_path, 'w') as file:
        json.dump(widget_details, file)
        file.close()


def app_category_zip(app_data, folder_path, prefix=None):
    connection = Connection(prefix=prefix)
    database = Database(prefix=prefix)
    app_category_details = list(
                connection.category_apps.find(
                    {"app_category_id": app_data.get("app_category_id"), "project_id": prefix}, {"_id": 0}
                )
            )
    app_category_folder = f"{database.configuration.name}.category_apps"
    app_category_data_folder_path = os.path.join(folder_path, app_category_folder)
    os.makedirs(app_category_data_folder_path)
    app_data_file_path = os.path.join(app_category_data_folder_path, f"{app_category_folder}.json")
    with open(app_data_file_path, 'w') as file:
        json.dump(app_category_details, file)
        file.close()


def modify_app_data(app_data):
    app_data["sharing_info"] = {}
    app_data["access_list"]["users"] = []
    app_data["access_list"]["access_groups"] = []


def dashboard_image_zip(dashboard_ids, folder_path, prefix=None):
    database = Database(prefix=prefix)
    for dashboard_id in dashboard_ids:
        image_url = f"{dashboard_image_url}{dashboard_id}&project_id={prefix}&lastmod={time.time() * 1000}"
        with httpx.Client() as client:
            response = client.get(
                url=image_url,
                timeout=20,
                cookies=cookie,
                headers=cookie,
            )
        dashboard_folder = f"{database.widget.name}.dashboard"
        dashboard_data_folder_path = os.path.join(folder_path, dashboard_folder)
        if response.status_code == 200:
            # Save the content of the response to a local file
            with open(os.path.join(dashboard_data_folder_path, f"{dashboard_id}.jpg"), 'wb') as file:
                file.write(response.content)
            print(f"Image downloaded and saved to {dashboard_data_folder_path}")
        else:
            print(f"Failed to download image. Status code: {response.status_code}")


def app_image_zip(images, folder_path):
    for image_name, image in images.items():
        image_url = f"{app_image_url}{image}&time={time.time() * 1000}"
        with httpx.Client() as client:
            response = client.get(
                url=image_url,
                timeout=20,
                cookies=cookie,
                headers=cookie,
            )
        app_image_folder_path = os.path.join(folder_path, image_name)
        os.makedirs(app_image_folder_path)
        if response.status_code == 200:
            # Save the content of the response to a local file
            with open(os.path.join(app_image_folder_path, image), 'wb') as file:
                file.write(response.content)
            print(f"Image downloaded and saved to {os.path.join(app_image_folder_path, image)}")
        else:
            print(f"Failed to download image. Status code: {response.status_code}")


def app_zip(app_name, prefix=None):
    connection = Connection(prefix=prefix)
    database = Database(prefix=prefix)
    folder_path = os.path.join(BASE_PATH, MOUNT_DIR, app_name)
    os.makedirs(folder_path, exist_ok=True)
    app_data = connection.customer_apps.find_one({"app_name": app_name}, {"_id": 0})
    lookups = app_data.get("lookups", [])
    lookup_details = list(
                connection.lookup_table.find(
                    {"lookup_name": {"$in": lookups}, "project_id": prefix}, {"_id": 0}
                )
            )
    dashboard_ids_publish = dashboard_ids_fetch(app_data.get("children", []))
    widget_ids = dashboard_zip(dashboard_ids_publish, folder_path, prefix)
    dashboard_image_zip(dashboard_ids_publish, folder_path, prefix)
    widget_zip(widget_ids, folder_path, prefix)
    images = {'app_image': app_data.get("meta", {}).get("image", {}).get("file_name", ""),
              'app_logo': app_data.get("meta", {}).get("app_logo", {}).get("file_name", "")}

    app_category_zip(app_data, folder_path, prefix)
    modify_app_data(app_data)
    app_image_zip(images, folder_path)
    app_data_folder = f"{database.configuration.name}.customer_apps"
    app_data_folder_path = os.path.join(folder_path, app_data_folder)
    os.makedirs(app_data_folder_path)
    app_data_file_path = os.path.join(app_data_folder_path, f"{app_data_folder}.json")
    with open(app_data_file_path, 'w') as file:
        json.dump([app_data], file)
        file.close()
    if lookup_details:
        lookup_data_folder = f"{database.configuration.name}.lookup_table"
        lookup_data_folder_path = os.path.join(app_name, lookup_data_folder)
        os.makedirs(lookup_data_folder_path)
        lookup_data_file_path = os.path.join(lookup_data_folder_path, f"{lookup_data_folder}.json")
        with open(lookup_data_file_path, 'w') as file:
            json.dump(lookup_details, file)
    zip_folder(folder_path, app_name)
    shutil.rmtree(folder_path)


def zip_folder(folder_path, zip_filename):
    shutil.make_archive(zip_filename, 'zip', folder_path)


if __name__ == "__main__":
    app_zip(APP_NAME, PREFIX)
