from dotenv import load_dotenv
load_dotenv()
import os
import shutil

BASE_PATH = os.environ.get("BASE_PATH")
MOUNT_DIR = os.environ.get("MOUNT_DIR")
APP_NAME = os.environ.get("APP_NAME")

folder1_path = os.path.join(BASE_PATH, MOUNT_DIR, APP_NAME, "app_image")
folder2_path = os.path.join(BASE_PATH, MOUNT_DIR, APP_NAME, "app_logo")
destination_folder = os.path.join(BASE_PATH, "metadata/images/apps")


def get_image_names(folder_path):
    try:
        # List all files in the folder
        files = os.listdir(folder_path)

        # Filter only files with common image extensions (you can extend this list)
        image_files = [file for file in files if file.lower().endswith(('.jpg', '.jpeg', '.png', '.gif'))]

        return image_files
    except Exception as e:
        print(f"Error getting image names from folder '{folder_path}': {e}")
        return []


def move_images(image_paths, destination_folder):
    for image_path in image_paths:
        try:
            # Extract the image file name from the path
            image_name = os.path.basename(image_path)

            # Create the destination path by combining the destination folder and image name
            destination_path = os.path.join(destination_folder, image_name)

            # Move the image to the destination folder
            shutil.move(image_path, destination_path)

            print(f"Image '{image_name}' moved successfully to '{destination_folder}'.")
        except Exception as e:
            print(f"Error moving image '{image_path}': {e}")


if __name__ == "__main__":
    image1_path = get_image_names(folder1_path)
    image2_path = get_image_names(folder2_path)

    if image1_path and image2_path:
        # Call the function with the list of image paths and the destination folder
        move_images([f"{folder1_path}/{image1_path[0]}", f"{folder2_path}/{image2_path[0]}"], destination_folder)
