from dotenv import load_dotenv
import os
load_dotenv()
from app_clone_script_new import extract_app_zip
from image_move_script import get_image_names, move_images

USER_ID = os.environ.get("USER_ID")
PROJECT_ID = os.environ.get("PROJECT_ID")
APP_NAME = os.environ.get("APP_NAME")
PREFIX = os.environ.get("PREFIX")
BASE_PATH = os.environ.get("BASE_PATH")
MOUNT_DIR = os.environ.get("MOUNT_DIR")

folder1_path = os.path.join(BASE_PATH, MOUNT_DIR, APP_NAME, "app_image")
folder2_path = os.path.join(BASE_PATH, MOUNT_DIR, APP_NAME, "app_logo")
destination_folder = os.path.join(BASE_PATH, "metadata/images/apps")


if __name__ == "__main__":
    extract_app_zip(APP_NAME, USER_ID, PROJECT_ID, PREFIX)
    image1_path = get_image_names(folder1_path)
    image2_path = get_image_names(folder2_path)

    if image1_path and image2_path:
        # Call the function with the list of image paths and the destination folder
        move_images([f"{folder1_path}/{image1_path[0]}", f"{folder2_path}/{image2_path[0]}"], destination_folder)