import os
import zipfile
import json
from PIL import Image


class CloneScriptHelper:

    def __int__(self):
        pass

    @staticmethod
    def list_folders(path):
        # Get a list of all items (files and directories) in the specified path
        items = os.listdir(path)

        # Filter out only directories
        folders = [item for item in items if os.path.isdir(os.path.join(path, item))]

        return folders

    @staticmethod
    def unzip_file(zip_filename, extract_path):
        with zipfile.ZipFile(zip_filename, 'r') as zip_ref:
            zip_ref.extractall(extract_path)
        print(f"File {zip_filename} successfully extracted to {extract_path}")

    @staticmethod
    def read_json_file(file_path):
        with open(file_path, 'r') as file:
            data = json.load(file)
        return data

    @staticmethod
    def is_image(file_path):
        try:
            with Image.open(file_path):
                return True
        except (IOError, OSError):
            return False

    def list_images_in_folder(self, folder_path):
        all_files = os.listdir(folder_path)
        image_files = [file for file in all_files if self.is_image(os.path.join(folder_path, file))]

        return image_files