from sqlalchemy import VARCHAR, Column, Integer, Index, FLOAT, BOOLEAN
from datetime import datetime
from sqlalchemy.ext.declarative import declarative_base

Base = declarative_base()


class TrendsMasterTable(Base):
    __tablename__ = "trends_master_tbl"

    id = Column(Integer, primary_key=True, autoincrement=True)
    mapping_id = Column(VARCHAR, nullable=True)
    department = Column(VARCHAR, nullable=True)
    sub_menu = Column(VARCHAR, nullable=True)
    form_id = Column(VARCHAR, nullable=True)
    line_id = Column(VARCHAR, nullable=True)
    equipment_id = Column(VARCHAR, nullable=True)
    parameter = Column(VARCHAR, nullable=True)
    trend_captured = Column(BOOLEAN, nullable=True)
    min = Column(FLOAT, nullable=True)
    max = Column(FLOAT, nullable=True)
    actual_value = Column(FLOAT, nullable=True)
    recheck_value = Column(FLOAT, nullable=True)

    index_name = Index('trends_master_indx', mapping_id, department,
                       sub_menu, form_id, line_id, equipment_id,
                       parameter)


class TrendsFormTable(Base):
    __tablename__ = "trends_form_tbl"

    id = Column(Integer, primary_key=True, autoincrement=True)
    mapping_id = Column(VARCHAR, nullable=True)
    value = Column(VARCHAR, nullable=True)
    time = Column(datetime, nullable=True)

    index_name = Index('trends_form_indx', mapping_id, time)
