"""
constants.py - Application Constants

This module defines various constants used in the application.

"""


class APIConstants:
    """
    Constants related to API endpoints
    """

    SHUTDOWN = "shutdown"
    HEALTH_CHECK = "/healthcheck"
    TRENDS_ASYNC_SERVICE = "/trends_async"


class MainConstants:
    """
    Constants related to the main application
    """

    META_TAG_JSON = {
        "name": "PepsiCO: Trends Dashboard",
        "description": "Service for pushing data into the Postgres table",
    }
    DESCRIPTION_KEY = "Trends Dashboard"
    TOKEN_KEY = "token"


class Constants:
    """
    Constants related to the application
    """
    EXCEPTION_RAISER = "Exception ->{}"
    TRENDS_HANDLING_ENDPOINT = "Trends Handler Endpoints"


class LoggerConstants:
    LOGGER_1 = ""
