import copy
from datetime import datetime
from scripts.constants import Constants
from scripts.core.db.postgres import database_init
from scripts.core.db.postgres.psql_query import (
    get_unique_departments, get_unique_function,
    get_unique_form, get_unique_filters
)
from scripts.core.schemas.postgres import TableObject
from scripts.core.logging.application_logging import logger
from scripts.core.exception.app_exceptions import GeneralException
from scripts.core.schemas.postgres.postgres_tables import \
    TrendsMasterTable, TrendsFormTable


class TrendsDashboardHandler:
    """
        Class responsible for creating tables and performing calculations for
        PepsiCo metrics.
    """

    def get_trends_metadata(self, request_data):
        """
        get_trends_metadata
        """
        filter_flag = False

        final_metadata_json = dict(
            values=[]
        )

        logger.info("Database initialization")
        db_init = database_init()

        # Creating table object
        trends_master_tbl_obj = TableObject(
            db=db_init, table_name=TrendsMasterTable
        )

        if request_data.department and request_data.function and request_data.form:
            filter_flag = True
            filter_name = Constants.LINE
            filter_query = get_unique_filters(
                table=TrendsMasterTable,
                department=request_data.department,
                function=request_data.function,
                form=request_data.form
            )

        elif request_data.department and request_data.function:
            filter_name = Constants.FORM
            filter_query = get_unique_form(
                table=TrendsMasterTable,
                department=request_data.department,
                function=request_data.function
            )

        elif request_data.department:
            filter_name = Constants.FUNCTION
            filter_query = get_unique_function(
                table=TrendsMasterTable,
                department=request_data.department
            )

        else:
            filter_name = Constants.DEPARTMENT
            filter_query = get_unique_departments(
                table=TrendsMasterTable
            )

        # Getting response from the Trends Master Table
        response_data = trends_master_tbl_obj.execute_query(
            query=filter_query
        )

        if response_data and not filter_flag:
            final_metadata_json[Constants.FILTER_NAME] = filter_name
            for each_metadata in response_data:
                final_metadata_json[Constants.VALUES].append(
                    dict(
                        key=each_metadata[Constants.DATA],
                        label=each_metadata[Constants.DATA],
                    )
                )

        return final_metadata_json

    def get_trends_data(self, request_data):
        """
        Docstring
        """
        return True
