from scripts.constants import Constants

from sqlalchemy import select, and_, cast, Text


def get_unique_departments(table):
    return select(
        table.department.label(Constants.DATA)
    ).distinct()


def get_unique_function(table, department):
    return select(
        table.function.label(Constants.DATA)
    ).distinct().where(
        table.department == department
    )


def get_unique_form(table, department, function):
    return select(
        table.form.label(Constants.DATA)
    ).distinct().where(
        and_(
            table.department == department,
            table.function == function
        ))


def get_unique_filters(table, department, function, form):
    return select(
        cast(table.filter, Text).label(Constants.DATA)
    ).distinct().where(
        and_(
            table.department == department,
            table.function == function,
            table.form == form
        )
    )
