"""
constants.py - Application Constants

This module defines various constants used in the application.

"""


class APIConstants:
    """
    Constants related to API endpoints
    """

    SHUTDOWN = "shutdown"
    HEALTH_CHECK = "/healthcheck"
    DASHBOARD_METADATA_ENDPOINT = "/get_filter"
    DASHBOARD_DATA_ENDPOINT = "/get_data"


class MainConstants:
    """
    Constants related to the main application
    """

    META_TAG_JSON = {
        "name": "PepsiCO: Trends Dashboard",
        "description": "Service for pushing each_data into the Postgres table",
    }
    DESCRIPTION_KEY = "Trends Dashboard"
    TOKEN_KEY = "token"


class Constants:
    """
    Constants related to the application
    """
    EXCEPTION_RAISER = "Exception ->{}"
    TRENDS_HANDLING_ENDPOINT = "Trends Handler Endpoints"
    DATA = "each_data"
    LINE = "line"
    DEPARTMENT = "department"
    FORM = "form"
    FUNCTION = "function"
    VALUES = "values"
    FILTER_NAME = "filter_name"

    HEADER_CONTENT = [
        {
            "key": "date",
            "label": "Date"
        },
        {
            "key": "parameter",
            "label": "Parameter"
        },
        {
            "key": "value",
            "label": "Value"
        },
        {
            "key": "mean",
            "label": "Mean"
        },
        {
            "key": "upper_limit",
            "label": "Upper Limit"
        },
        {
            "key": "lower_limit",
            "label": "Lower Limit"
        }
    ]


class LoggerConstants:
    LOGGER_1 = ""
