"""
app.py - Trends Dashboard

    This script initializes and configures the
    PepsiCO: Trends Dashboard

    Usage:
        Start the FastAPI application by running this script .

Developer: str = 'Suryakant Soni - {H115-301}'
"""

import uvicorn
from fastapi import FastAPI
from __version__ import version
from scripts.core.service import api_router
from scripts.constants import MainConstants
from fastapi.middleware.cors import CORSMiddleware
from scripts.configurations import service_details

app = FastAPI(
    title="PepsiCO: Trends Dashboard",
    version=version,
    description=MainConstants.DESCRIPTION_KEY,
    openapi_tags=[MainConstants.META_TAG_JSON]
)

app.include_router(router=api_router)

origins = ["*"]
app.add_middleware(
    CORSMiddleware,
    allow_origins=origins,
    allow_credentials=True,
    allow_methods=["*"],
    allow_headers=["*"],
    expose_headers=[MainConstants.TOKEN_KEY]
)

if __name__ == '__main__':
    uvicorn.run(app=app,
                host=service_details.host,
                port=int(service_details.port))
