from __future__ import annotations
import json
from datetime import datetime
from typing import Optional, Any
from pydantic import BaseModel


class DashboardFilterInput(BaseModel):
    department: Optional[str] = None
    function: Optional[str] = None
    form: Optional[str] = None
    current_level: Optional[int] = None
    filter: Optional[dict] = None


class DashboardFilterOutput(BaseModel):
    filter_name: str
    values: list
    current_level: int


class DashboardFormInput(BaseModel):
    start_date: Optional[str] = None
    end_date: Optional[str] = None
    mapping_id: Optional[str] = None
    department: Optional[str] = None
    function: Optional[str] = None
    form: Optional[str] = None
    parameter: Optional[str] = None


class DashboardFormOutput(BaseModel):
    filter_name: str
    values: list
