import copy
from datetime import datetime

from scripts.configurations import postgres_details
from scripts.constants import Constants
from scripts.core.db.postgres import database_init
from scripts.core.db.postgres.psql_query import (
    get_departments, get_parameters, get_filter_query
)
from scripts.core.schemas.postgres import TableObject
from scripts.core.logging.application_logging import logger
from scripts.core.exception.app_exceptions import GeneralException
from scripts.core.schemas.postgres.postgres_tables import \
    TrendsMasterTable, TrendsFormTable


class TrendsDashboardHandler:
    """
        Class responsible for creating tables and performing calculations for
        PepsiCo metrics.
    """

    def get_trends_metadata(self, request_data):
        """
        get_trends_metadata
        """
        final_metadata_json = dict()
        clause = None

        logger.info("Database initialization")
        db_init = database_init()

        # Creating table object
        trends_master_tbl_obj = TableObject(
            db=db_init, table_name=TrendsMasterTable
        )

        if request_data.current_level or request_data.current_level == 0:
            final_metadata_json["current_level"] = request_data.current_level + 1
            filter_query, clause = get_filter_query(
                current_level=request_data.current_level,
                department=request_data.department,
                function=request_data.function,
                form=request_data.form,
                filter_value=request_data.filter,
                table=postgres_details.master_tbl
            )
        else:
            final_metadata_json["current_level"] = 0
            filter_query = get_departments(
                table=TrendsMasterTable
            )

        # Getting response from the Trends Master Table
        response_data = trends_master_tbl_obj.execute_query(
            query=filter_query
        )
        parameter_flag = False

        if response_data:
            final_metadata_json, parameter_flag = self.get_response_data(
                response_data=response_data,
                final_metadata_json=final_metadata_json,
                parameter_flag=parameter_flag
            )

        if parameter_flag:
            filter_query = get_parameters(where_clause=clause)
            # Getting response from the Trends Master Table
            response_data = trends_master_tbl_obj.execute_query(
                query=filter_query
            )
            if response_data:
                final_metadata_json, parameter_flag = self.get_response_data(
                    response_data=response_data,
                    final_metadata_json=final_metadata_json,
                    parameter_flag=parameter_flag
                )

        return final_metadata_json

    def get_trends_data(self, request_data):
        """
        Docstring
        """
        return True

    def get_response_data(self, response_data, final_metadata_json, parameter_flag):
        values = []
        for each_data in response_data:
            if len(each_data) > 1:
                filter_name = list(each_data.items())
                if filter_name[1][1]:
                    values.append({
                        "key": filter_name[1][1],
                        "label": filter_name[1][1]
                    })
                else:
                    parameter_flag = True
                    break
                final_metadata_json["filter_name"] = filter_name[0][1]
                final_metadata_json["values"] = values
            elif len(each_data) == 1:
                filter_name = list(each_data.keys())[0]
                values.append({
                    "key": each_data[filter_name],
                    "label": each_data[filter_name]
                })
                final_metadata_json["filter_name"] = filter_name
                final_metadata_json["values"] = values
        return final_metadata_json, parameter_flag
