from scripts.constants import Constants
from sqlalchemy import select


def get_departments(table):
    return select(
        table.department
    ).distinct()


def get_filter_query(
        current_level, department=None, function=None,
        form=None, filter_value=None,
        table=None
):
    query = None
    clause = None

    if current_level == 0:
        query = f"""
        SELECT 
            DISTINCT FUNCTION
        FROM
            {table}
        WHERE  
            DEPARTMENT='{department}'
        ORDER BY
            FUNCTION
        """

    elif current_level == 1:
        query = f"""
        SELECT 
            DISTINCT FORM
        FROM
            {table}
        WHERE  
            DEPARTMENT='{department}' 
            AND FUNCTION='{function}'
        ORDER BY
            FORM
        """

    elif current_level >= 2:
        current_level -= 1

        where_clause = ""
        if current_level >= 2:
            query_parts = []
            for index, data in filter_value.items():
                key, value = list(data.items())[0]
                query_parts.append(
                    f"AND FILTER ->> 'l{int(index) + 1}-name' = '{key}'")
                query_parts.append(
                    f"AND FILTER ->> 'l{int(index) + 1}-value' = '{value}'")
            where_clause = "\n".join(query_parts)

        query = f"""
        SELECT 
            DISTINCT (FILTER ->> 'l{current_level}-name') AS L{current_level}_NAME,
            (FILTER ->> 'l{current_level}-value') AS L{current_level}_VALUE
        FROM
            {table}
        WHERE  
            DEPARTMENT='{department}' 
            AND FUNCTION='{function}'
            AND FORM='{form}'
            {where_clause}
        ORDER BY
            L{current_level}_NAME
        """
        clause = f"""
        WHERE  
            DEPARTMENT='{department}' 
            AND FUNCTION='{function}'
            AND FORM='{form}'
            {where_clause}
        """

    return query, clause


def get_parameters(where_clause):
    return f"""
    SELECT 
        DISTINCT PARAMETER
    FROM
        PUBLIC.TRENDS_MASTER_TBL_
    {where_clause}
    ORDER BY
        PARAMETER
    """
