"""
This __init__ file contains the configuration settings for the application
"""
from dotenv import load_dotenv
from pydantic_settings import BaseSettings

""" Loading dot env file"""
load_dotenv()


class ServiceDetails(BaseSettings):
    """
    Configuration class for Project details
    """

    host: str
    port: str


class PostgresDetails(BaseSettings):
    """
    Configuration class for PostgreSQL database details.

    Config:
        env_prefix (str): The environment variable prefix for PostgreSQL settings.
    """

    uri: str
    master_tbl: str

    class Config:
        env_prefix = "POSTGRES_"


class LoggingDetails(BaseSettings):
    """
    Configuration class for logging database details
    """

    log_base_path: str
    log_level: str
    max_bytes: int
    handler_type: str
    log_file_name: str
    backup_count: int


service_details = ServiceDetails()
postgres_details = PostgresDetails()
logging_details = LoggingDetails()
