# import time
# import requests
# from scripts.constants import Constants
# from scripts.core.logging.application_logging import logger
# from scripts.core.exception.app_exceptions import GeneralException
#
#
# class CommonUtility:
#     """
#     A utility class for common operations
#     """
#
#     def request_get(self, url, params, headers):
#         """
#         Sends an HTTP GET request and returns the JSON response.
#
#         Parameters:
#         - url (str): The URL for the GET request.
#         - headers (dict): The headers to be included in the GET request.
#
#         Returns:
#         - dict or None: The JSON response data if successful, or None if there is an
#           error.
#         """
#         response_data = None
#         try:
#             response_data = requests.get(
#                 url=url,
#                 params=params,
#                 headers=headers).json()
#         except GeneralException as err:
#             logger.error(f"Exception in GET API data: {err}")
#         return response_data
#
#     def request_post(self, url, headers):
#         """
#         Sends an HTTP POST request and returns the JSON response.
#
#         Parameters:
#         - url (str): The URL for the POST request.
#         - headers (dict): The JSON payload to be included in the POST request.
#
#         Returns:
#         - dict or None: The JSON response data if successful, or None if there is an
#           error.
#         """
#         response_data = None
#         try:
#             response_data = requests.post(
#                 url=url,
#                 json=headers).json()
#         except GeneralException as err:
#             logger.error(f"Exception in POST API data: {err}")
#         return response_data
